#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "dialog.h"

#include <iostream>
#include <QSqlDatabase>
#include <QSqlError>
#include <QSqlQuery>
#include <QSqlRecord>

#include <QtSql>
#include <QDataWidgetMapper>

QSqlDatabase DB;                     // ݿ
QSqlQueryModel  *qryModel;           // ݿģ
QSqlTableModel *tabModel;            // ģ
QItemSelectionModel *theSelection;   // ѡģ
QDataWidgetMapper *dataMapper;       // ӳ

MainWindow::MainWindow(QWidget *parent) :QMainWindow(parent),ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    // ݿ
    DB=QSqlDatabase::addDatabase("QSQLITE"); //  SQL LITEݿ
    DB.setDatabaseName("./database.db");     // ݿ
    if (!DB.open())
    {
       return;
    }

    // ݱ
    qryModel=new QSqlQueryModel(this);
    theSelection=new QItemSelectionModel(qryModel);

    qryModel->setQuery("SELECT id,name,sex,age,mobile,city FROM Student order by id");
    if (qryModel->lastError().isValid())
    {
        return;
    }

    // ֶ
    qryModel->setHeaderData(0,Qt::Horizontal,"ID");
    qryModel->setHeaderData(1,Qt::Horizontal,"Name");
    qryModel->setHeaderData(2,Qt::Horizontal,"Sex");
    qryModel->setHeaderData(3,Qt::Horizontal,"Age");
    qryModel->setHeaderData(4,Qt::Horizontal,"Mobile");
    qryModel->setHeaderData(5,Qt::Horizontal,"City");

    ui->tableView->setModel(qryModel);
    ui->tableView->setSelectionModel(theSelection);
    ui->tableView->setSelectionBehavior(QAbstractItemView::SelectRows);
    ui->tableView->setSelectionMode(QAbstractItemView::SingleSelection);
    ui->tableView->setAlternatingRowColors(true);

    // this->setCentralWidget(ui->tableView);
}

MainWindow::~MainWindow()
{
    delete ui;
}

// DialogԻ, 
void MainWindow::on_pushButton_update_clicked()
{
    int curRecNo=theSelection->currentIndex().row();
    QSqlRecord  curRec=qryModel->record(curRecNo); // ȡǰ¼
    int uid=curRec.value("id").toInt();            // ȡid

    QSqlQuery query;                               // ѯǰ¼ֶ
    query.prepare("select * from Student where id = :ID");
    query.bindValue(":ID",uid);
    query.exec();
    query.first();

    if (!query.isValid())                          // ǷΪЧ¼
        return;

    curRec=query.record();                                               // ȡǰ¼
    Dialog *WindowPtr=new Dialog(this);                                  // Ի
    Qt::WindowFlags flags=WindowPtr->windowFlags();
    WindowPtr->setWindowFlags(flags | Qt::MSWindowsFixedSizeDialogHint); // öԻ̶С

    WindowPtr->setUpdateRecord(curRec);  // öԻݺͽ
    int ret=WindowPtr->exec();           // ģ̬ʽʾԻ
    if (ret==QDialog::Accepted)          // OK
    {
        QSqlRecord recData=WindowPtr->getRecordData(); // öԻ򷵻صļ¼
        query.prepare("update Student set name=:Name, sex=:Sex,age=:Age, mobile=:Mobile, city=:City where id=:ID");

        query.bindValue(":ID",recData.value("id"));
        query.bindValue(":Name",recData.value("name"));
        query.bindValue(":Sex",recData.value("sex"));
        query.bindValue(":Age",recData.value("age"));
        query.bindValue(":Mobile",recData.value("mobile"));
        query.bindValue(":City",recData.value("city"));

        // ģ²ѯݣtableViewʾ
        if (query.exec())
        {
            qryModel->query().exec();
        }

    }
    delete WindowPtr;
}

// һ¼¼
void MainWindow::on_pushButton_insert_clicked()
{
    QSqlQuery query;
    query.exec("select * from Student where id =-1");    // ѯֶϢ,Ƿ
    QSqlRecord curRec=query.record();                    // ȡǰ¼,ʵΪռ¼
    curRec.setValue("id",qryModel->rowCount()+1001);

    Dialog *WindowPtr=new Dialog(this);
    Qt::WindowFlags flags=WindowPtr->windowFlags();
    WindowPtr->setWindowFlags(flags | Qt::MSWindowsFixedSizeDialogHint); // öԻ̶С
    WindowPtr->setInsertRecord(curRec);                                  // ¼
    int ret=WindowPtr->exec();                                           // ģ̬ʽʾԻ
    if (ret==QDialog::Accepted)                                          // OK
    {
        QSqlRecord  recData=WindowPtr->getRecordData();

        query.prepare("INSERT INTO Student(id,name,sex,age,mobile,city)"
                      " VALUES(:Id, :Name, :Sex, :Age, :Mobile, :City)");

        query.bindValue(":Id",recData.value("id"));
        query.bindValue(":Name",recData.value("name"));
        query.bindValue(":Sex",recData.value("sex"));
        query.bindValue(":Age",recData.value("age"));
        query.bindValue(":Mobile",recData.value("mobile"));
        query.bindValue(":City",recData.value("city"));

        if (query.exec())
        {
            QString sqlStr=qryModel->query().executedQuery(); // ִйSELECT
            qryModel->setQuery(sqlStr);                       // ²ѯ
        }
    }
    delete WindowPtr;
}

// ɾѡм¼
void MainWindow::on_pushButton_delete_clicked()
{
    int curRecNo=theSelection->currentIndex().row();
    QSqlRecord  curRec=qryModel->record(curRecNo);     // ȡǰ¼
    if (curRec.isEmpty())                              // ǰΪռ¼
        return;

    int uid=curRec.value("id").toInt();                // ȡԱ
    QSqlQuery query;
    query.prepare("delete from Student where id = :ID");
    query.bindValue(":ID",uid);

    if (query.exec())
    {
        QString sqlStr=qryModel->query().executedQuery(); // ִйSELECT
        qryModel->setQuery(sqlStr);                       // ²ѯ
    }
}

// ˵1
void MainWindow::on_pushButton_AddAge_clicked()
{
    QSqlQuery qryEmpList;                                       // ԱϢб
    qryEmpList.exec("SELECT id,age FROM Student ORDER BY id");
    qryEmpList.first();

    QSqlQuery qryUpdate;                                        // ʱQSqlQuery
    qryUpdate.prepare("UPDATE Student SET age=:Age WHERE id = :ID");

    while (qryEmpList.isValid())                      // ǰ¼Ч
    {
        int uid=qryEmpList.value("id").toInt();       // ȡuid
        int uage=qryEmpList.value("age").toInt();     // ȡage
        uage=uage+1;                                  // +1

        qryUpdate.bindValue(":ID",uid);
        qryUpdate.bindValue(":Age",uage);   // SQL
        qryUpdate.exec();                   // ִupdate

        if (!qryEmpList.next())             // ƶһ¼жǷĩβ
            break;
    }
    // ģ²ѯݣtableViewʾ
    qryModel->query().exec();
}


